
///////////////////////////////////////////////////////////////////////////////
// Simple "Hello World" widget that demonstrates the WRTKit UI toolkit.

// Reference to the WRTKit user interface manager and main view.
var uiManager;
var mainView;

// Reference to controls in the main view.
var helloButton;
var nameField;

//about view label control
var aboutLabel;

// Constants for menu item identifiers.
var MENU_ITEM_ABOUT = 0;
var MENU_ITEM_SMALLER_FONT=1;
var MENU_ITEM_LARGER_FONT=2;
var MENU_ITEM_SMALLEST_FONT=3;
var MENU_ITEM_LARGEST_FONT=4;

// Called from the onload event handler to initialize the widget.
function init() {
	
	//create about menu
	var aboutMenuItem = new MenuItem("About", MENU_ITEM_ABOUT);
	aboutMenuItem.onSelect = menuItemSelected;
	menu.append(aboutMenuItem);
	
	var largerFontMenuItem = new MenuItem("Larger font", MENU_ITEM_LARGER_FONT);
	largerFontMenuItem.onSelect = menuItemSelected;
	menu.append(largerFontMenuItem);
	
	var smallerFontMenuItem = new MenuItem("Smaller font", MENU_ITEM_SMALLER_FONT);
	smallerFontMenuItem.onSelect = menuItemSelected;
	menu.append(smallerFontMenuItem);
	
	var largestFontMenuItem = new MenuItem("Default large font", MENU_ITEM_LARGEST_FONT);
	largestFontMenuItem.onSelect = menuItemSelected;
	menu.append(largestFontMenuItem);
	
	var smallestFontMenuItem = new MenuItem("Default small font", MENU_ITEM_SMALLEST_FONT);
	smallestFontMenuItem.onSelect = menuItemSelected;
	menu.append(smallestFontMenuItem);
	
    // set tab-navigation mode and show softkeys
    // (only if we are in the WRT environment)
    if (window.widget) {
        widget.setNavigationEnabled(false);
        menu.showSoftkeys();
    }
    
    // create UI manager
    uiManager = new UIManager();
    
    // create main view
    mainView = new ListView(null, "Hello World");
    
	//Create about view
	aboutView = new ListView(null, "Hello World");
	
    // add a text field to the view
    nameField = new TextField(null, "Enter your name");
    mainView.addControl(nameField);
    
    // add a button to the view
    helloButton = new FormButton(null, "Say Hello!");
    helloButton.addEventListener("ActionPerformed", helloButtonClicked);
    mainView.addControl(helloButton);
    
	// About lable control
	aboutLabel = new Label();
	aboutView.addControl(aboutLabel);
	
    // display the main view
    uiManager.setView(mainView);
    setDefaultFontSizeForScreenSize();
}

// Show main view.
function showMainView() {
    
    // set right softkey to "exit"
    if (window.widget) {
        menu.setRightSoftkeyLabel("", null);
    }
    
    // show the main view
    uiManager.setView(mainView);
}
// Callback for when menu items are selected.
function menuItemSelected(id) {
    switch (id) {
       	case MENU_ITEM_ABOUT:
			showAboutView();
			break;
        case MENU_ITEM_LARGEST_FONT:
			setLargeView();
            break;
        case MENU_ITEM_LARGER_FONT:
        	increaseFontSize();
            break;
        case MENU_ITEM_SMALLEST_FONT:
			setSmallView();
            break;
        case MENU_ITEM_SMALLER_FONT:
            decreaseFontSize();
            break;
    }
}

//Displays the About view
function showAboutView(){
	aboutLabel.setText("This Widget includes software licensed from Nokia &copy 2008");
	
	setAboutViewSoftkeys();
	uiManager.setView(aboutView);
}

// Sets the soft keys for about view.
function setAboutViewSoftkeys() {
    if (window.widget) {
        // set right soft key to "Ok" (returns to main view)
        menu.setRightSoftkeyLabel("Ok", showMainView);
    }
}

// Called when the hello-button is clicked.
function helloButtonClicked(eventObject) {
    var nameString = nameField.getText();
    if (nameString.length == "") {
        uiManager.showNotification(3000, "warning", "Please enter your name!");
    } else {
        uiManager.showNotification(3000, "info", "Hello " + nameString + "!");
    }
}
